<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="FindType"></xsl:variable>
<xsl:variable name="FindText"></xsl:variable>
<xsl:template match="/">
	<table id='tblfoundparts' width='100%' border='1' cellspacing='0' cellpadding='1' bordercolordark='#FFFFFF' bordercolor='#777777' style='font-family: Arial, Helvetica; font-size: 8pt;'>
		<tr height='24' style='color:captiontext;' bgcolor='activecaption'>
			<th colspan='10'>
				<div align='left'>
					FOUND PARTS
				</div>
			</th>
		</tr>
		<tr height='23' bgcolor='threedface'>
			<th>NO.</th>
			<th>CHG</th>
<!--
			<th style="font-family:JVC Service,Arial,Helvetica">!</th>
-->
			<th><img src="../js/safety.png" width="12" height="10" border="0"/></th>
			<th>REF NO.</th>
			<th>OR</th>
			<th>PART NO.</th>
			<th>PART NAME</th>
			<th>AREA</th>
			<th>BLOCK</th>
			<th>MCI</th>
		</tr>
		<xsl:if test="$FindType = 'ref' or $FindType = ''">
			<xsl:if test="$FindText != ''">
				<xsl:apply-templates select="//ROW[contains(SYMBOL,$FindText)]">
					<xsl:sort select="SYMBOL" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$FindType = 'number'">
			<xsl:if test="$FindText != ''">
				<xsl:apply-templates select="//ROW[contains(PART_NO,$FindText)]">
					<xsl:sort select="SYMBOL" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$FindType = 'name'">
			<xsl:if test="$FindText != ''">
				<xsl:apply-templates select="//ROW[contains(PART_NAME,$FindText)]">
					<xsl:sort select="SYMBOL" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$FindText = ''">
			<xsl:apply-templates select="//ROW">
					<xsl:sort select="SYMBOL" data-type="text" order="ascending"/>
			</xsl:apply-templates>
		</xsl:if>
	</table>
</xsl:template>

<xsl:template match="PARTSLIST/ROW">
	<tr height='23'>
		<td nowrap="nowrap">
			<xsl:value-of select="position()"/>
		</td>
		<td nowrap="nowrap" align="center">
			<xsl:if test="@CHG[. != '']"><xsl:value-of select="@CHG"/></xsl:if>
			<xsl:if test="@CHG[. = '']"><br/></xsl:if>
		</td>
		<td align="center" nowrap="nowrap">
			<xsl:if test="SAFETY_FLG[. != '']">
<!--
				<xsl:attribute name="style">font-family:JVC Service,Arial,Helvetica</xsl:attribute>
				<xsl:value-of select="SAFETY_FLG"/>
-->
				<img src="../js/safety.png" width="12" height="10" border="0"/>
			</xsl:if>
			<xsl:if test="SAFETY_FLG[. = '']">
				<br/>
			</xsl:if>
		</td>
		<td nowrap="nowrap">
			<a>
				<xsl:attribute name="href">
					javascript:opener.globalSerachPartsRef('<xsl:value-of select="SYMBOL"/>','<xsl:value-of select="BLOCK_NO"/>');window.close();
				</xsl:attribute>
				<xsl:if test="SYMBOL[. != '']"><xsl:value-of select="SYMBOL"/></xsl:if>
				<xsl:if test="SYMBOL[. = '']"><br/></xsl:if>
			</a>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="OR_FLG[. != '']"><xsl:value-of select="OR_FLG"/></xsl:if>
			<xsl:if test="OR_FLG[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="PART_NO[. != '']"><xsl:value-of select="PART_NO"/></xsl:if>
			<xsl:if test="PART_NO[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="PART_NAME[. != '']"><xsl:value-of select="PART_NAME"/></xsl:if>
			<xsl:if test="PART_NAME[. = '']"><br/></xsl:if>
		</td>
		<td >
			<xsl:if test="AREA[. != '']"><xsl:value-of select="AREA"/></xsl:if>
			<xsl:if test="AREA[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="BLOCK_NO[. != '']"><xsl:value-of select="BLOCK_NO"/></xsl:if>
			<xsl:if test="BLOCK_NO[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<a>
				<xsl:attribute name="href">
					<xsl:value-of select="RESERVED1/@LINK"/>
				</xsl:attribute>
				<xsl:attribute name="target">_blank</xsl:attribute>
				<xsl:if test="RESERVED1[. != '']"><xsl:value-of select="RESERVED1"/></xsl:if>
				<xsl:if test="RESERVED1[. = '']"><br/></xsl:if>
			</a>
		</td>
	</tr>
</xsl:template>
</xsl:stylesheet>
